/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.builtin;

import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemNbtCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.ItemTagCondition;
import net.puffish.skillsmod.api.experience.calculation.parameter.EffectParameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.experience.calculation.CalculationManager;

public class EatFoodExperienceSource
implements ExperienceSource {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("eat_food");
    private static final Map<String, ConditionFactory<Context>> CONDITIONS = Map.ofEntries(Map.entry("item", ItemCondition.factory().map(c -> c.map(Context::item))), Map.entry("item_nbt", ItemNbtCondition.factory().map(c -> c.map(Context::item))), Map.entry("item_tag", ItemTagCondition.factory().map(c -> c.map(Context::item))));
    private static final Map<String, ParameterFactory<Context>> PARAMETERS = Map.ofEntries(Map.entry("player_effect", EffectParameter.factory().map(p -> p.map(Context::player))), Map.entry("food_hunger", ParameterFactory.simple(Context::hunger)), Map.entry("food_saturation", ParameterFactory.simple(Context::saturation)));
    private final CalculationManager<Context> manager;

    private EatFoodExperienceSource(CalculationManager<Context> calculated) {
        this.manager = calculated;
    }

    public static void register() {
        SkillsAPI.registerExperienceSourceWithData(ID, (json, context) -> json.getAsObject().andThen(rootObject -> EatFoodExperienceSource.create(rootObject, context)));
    }

    private static Result<EatFoodExperienceSource, Failure> create(JsonObjectWrapper rootObject, ConfigContext context) {
        return CalculationManager.create(rootObject, CONDITIONS, PARAMETERS, context).mapSuccess(EatFoodExperienceSource::new);
    }

    public int getValue(ServerPlayer player, ItemStack itemStack) {
        return this.manager.getValue(new Context(player, itemStack));
    }

    @Override
    public void dispose(MinecraftServer server) {
    }

    private record Context(ServerPlayer player, ItemStack item) {
        public double hunger() {
            FoodProperties fc = this.item.m_41720_().m_41473_();
            return fc == null ? 0.0 : (double)fc.m_38744_();
        }

        public double saturation() {
            FoodProperties fc = this.item.m_41720_().m_41473_();
            return fc == null ? 0.0 : (double)fc.m_38745_();
        }
    }
}

